//
//  GSLayer-Transformation.h
//  TransformPanel
//
//  Created by Georg Seifert on 16.07.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <GlyphsCore/GSLayer.h>

#define defaultCorrectContrast 0.5
#define defaultCorrectShape 0.5
#define defaultCorrectThickness 1

@interface GSLayer (Transformation)

- (void)slantX:(CGFloat)angle origin:(CGFloat)origin doCorrection:(BOOL)correction checkSelection:(BOOL)checkSelection;

- (void)slantX:(CGFloat)angle origin:(CGFloat)origin correctContrast:(CGFloat)correctContrast correctShape:(CGFloat)shape correctThickness:(CGFloat)thickness checkSelection:(BOOL)checkSelection;

- (void)slantY:(CGFloat)angle origin:(CGFloat)origin checkSelection:(BOOL)checkSelection;

- (void)doSlantingCorrectionWithAngle:(CGFloat)angle checkSelection:(BOOL)checkSelection;

- (void)doSlantingCorrectionWithAngle:(CGFloat)angle correctContrast:(CGFloat)correctContrast correctShape:(CGFloat)correctShape correctThickness:(CGFloat)correctThickness checkSelection:(BOOL)checkSelection;

- (void)doSlantingCorrectionWithAngle:(CGFloat)angle checkSelection:(BOOL)checkSelection correctContrast:(CGFloat)correctContrast correctShape:(CGFloat)correctShape correctThickness:(CGFloat)correctThickness horizontalStem:(CGFloat)horizontalStem verticalStem:(CGFloat)verticalStem center:(NSPoint)center;

@end
